## CONTENTS OF THIS FILE

* Introduction
* Requirements
* Installation
* Configuration
* Features
* Customization
* CSS Selectors
* Testing (GitLab CI)
* Troubleshooting
* Maintainers

## INTRODUCTION

Hover Card is a Drupal module that displays user information in an elegant popup
card when you hover over user links. Built on the modern Tippy.js library, it
provides a clean, accessible, and highly configurable way to show user details
without leaving the current page.

* For a full description of the module, visit the project page:
  https://www.drupal.org/project/hover_card

* To submit bug reports and feature suggestions, or to track changes:
  https://www.drupal.org/project/issues/hover_card

## REQUIREMENTS

* **Drupal 10.3 or higher** (Drupal 11 fully supported)
* No additional Drupal modules required
* All JavaScript dependencies (Tippy.js and Popper.js) are loaded from CDN

**Note:** This module requires at least Drupal 10.3 because it uses modern
features like `#config_target` for automatic configuration handling and
constructor property promotion.

## INSTALLATION

* Install the module using Composer:
  ```
  composer require drupal/hover_card
  ```

* Enable the Hover Card module via the admin interface or using Drush:
  ```
  drush en hover_card
  ```

* Clear cache:
  ```
  drush cr
  ```

## CONFIGURATION

Configure the module at: **Admin > Configuration > People > Hover Card**
(`/admin/config/people/hover-card`)

### Permissions

Grant the **"View hover cards"** permission to roles that should see hover cards:

* Navigate to **Admin > People > Permissions** (`/admin/people/permissions`)
* Enable "View hover cards" for desired roles (Authenticated User, Anonymous User, etc.)
* This allows fine-grained control - you can enable hover cards for anonymous users without granting full user profile access

### Display Settings

Choose which user information fields to display in the hover card:

* **Display user picture** (default: enabled)
    - Shows the user's profile picture if available

* **Display email address** (default: disabled)
    - Shows the user's email address with a mailto link

* **Display user roles** (default: enabled)
    - Shows all roles assigned to the user

* **Display member since date** (default: disabled)
    - Shows when the user account was created

* **Display last access date** (default: disabled)
    - Shows when the user last accessed the site

* **Display user bio/description** (default: disabled)
    - Shows the user's bio from the `field_description` field if available
    - Bio text is truncated to 200 characters in the hover card

**Note:** The user's display name is always shown and cannot be disabled.

### Custom User Fields (Dynamic)

**One of the most powerful features:** The module automatically discovers any
custom fields you add to the user entity and makes them available for display in
the hover card.

When you add new fields to your user entity (e.g., phone number, department,
location, social media links), they will automatically appear in the "Custom
User Fields" section of the configuration form. Simply enable the ones you want
to display.

Supported field types include:

* Text fields (string, text, text_long, text_with_summary)
* Numeric fields (integer, decimal, float)
* Boolean fields (checkbox)
* Date/time fields
* Email and telephone fields
* Link fields
* List fields (select lists)
* Entity reference fields
* Image and file fields
* And more!

The module intelligently formats each field type for optimal display in the
hover card.

### Advanced Settings

* **CSS Selector** (default:
  `a.username, span[rel="schema:author"] > a, span.node__author a`)
    - Customize which links trigger the hover card
    - Use standard CSS selector syntax
    - Multiple selectors can be separated by commas
    - Default includes Olivero theme compatibility (`span.node__author a`)
    - **See SELECTORS.md for detailed documentation on CSS selectors**

## FEATURES

### Modern Technology Stack

* Built on **Tippy.js 6.3.7** - A modern, accessible tooltip library
* No jQuery dependency - Uses vanilla JavaScript
* Responsive and mobile-friendly
* Smooth fade animations
* Automatic positioning with Popper.js

### Performance

* Lazy loading - User data is fetched only when hovering
* Cached content - Data is loaded once per user
* Lightweight - Minimal performance impact

### Accessibility

* Keyboard accessible (triggered by focus)
* Semantic HTML structure
* Proper ARIA attributes from Tippy.js
* High contrast support

### Drupal 11 Compatible

* Full Drupal 11 compatibility
* Modern PHP 8.1+ type hints
* Follows Drupal coding standards
* Proper dependency injection
* Service-based architecture
* BEM methodology for maintainable CSS

## CSS SELECTORS

The module targets user links using CSS selectors. The default selector works
with:

- Olivero theme (Drupal 10/11 default): `span.node__author a`
- Schema.org markup: `span[rel="schema:author"] > a`
- Legacy/contrib themes: `a.username`

**For detailed information about CSS selectors, theme compatibility, and
customization examples, see SELECTORS.md**

## CUSTOMIZATION

### CSS Customization

The module uses BEM (Block Element Modifier) methodology for CSS classes:

```css
/* Block: Main container */
.hover-card {
}

/* Elements: Component parts */
.hover-card__image {
}

.hover-card__info {
}

.hover-card__name {
}

.hover-card__mail {
}

.hover-card__link {
}

.hover-card__roles {
}

.hover-card__member-since {
}

.hover-card__last-access {
}

.hover-card__bio {
}

.hover-card__field {
}

.hover-card__label {
}

/* Modifiers: State variations */
.hover-card--loading {
}

.hover-card--error {
}
```

Override these in your theme's CSS file. The BEM structure provides clear component hierarchy and makes customization more maintainable.

### Template Customization

Copy `templates/hover_card.html.twig` to your theme and customize as needed.

### Targeting Custom User Links

If your theme uses different classes for user links, update the CSS selector in
the configuration form. For example:

* To target all links in a specific region:
  ```
  .region-sidebar a[href*="/user/"]
  ```

* To target custom classes:
  ```
  a.user-link, .author-name a
  ```

## TESTING (GITLAB CI)

This module includes GitLab CI configuration for automated testing on
Drupal.org's
infrastructure.

### For Contributors

When you submit a merge request, automated tests will run to ensure:

- Code quality and Drupal coding standards
- Compatibility with supported Drupal versions
- No PHP errors or deprecations

Tests run automatically on:

- Merge requests
- Commits to the main branch
- Tagged releases

### For Maintainers

The `.gitlab-ci.yml` file uses the Drupal Association's template for
standardized
testing. To customize testing:

1. Edit `.gitlab-ci.yml`
2. Uncomment and modify variables as needed
3.

See https://www.drupal.org/docs/develop/git/using-gitlab-to-contribute-to-drupal/gitlab-ci

The template is automatically updated by the Drupal Association, so your testing
stays current with the latest Drupal versions and environments.

## TROUBLESHOOTING

### Hover cards not appearing

* Clear Drupal cache: `drush cr`
* Check that user links have the correct CSS class or match your selector
* Verify JavaScript is not blocked in browser console
* Ensure users have "view hover cards" permission at `/admin/people/permissions`

### Wrong user information displayed

* Clear cache after changing configuration
* Verify the user profile has the fields you're trying to display

### Bio/description not showing

* Ensure the user has a `field_description` field
* This field must be added separately if not present

### Styling issues

* Check for CSS conflicts with your theme
* Use browser developer tools to inspect applied styles
* Override CSS in your theme as needed

### CDN connectivity issues

* If Tippy.js fails to load from CDN, check network connectivity
* Consider using a local copy if needed (requires library modification)

## MAINTAINERS

Current maintainers:

* Rishi B. Kulshreshtha - https://www.drupal.org/user/1403808
