<?php

namespace Drupal\hover_card\Controller;

use Drupal\Core\Controller\ControllerBase;
use Drupal\Core\Render\RendererInterface;
use Drupal\hover_card\Service\HoverCardDataService;
use Drupal\user\UserInterface;
use Symfony\Component\DependencyInjection\ContainerInterface;
use Symfony\Component\HttpFoundation\Response;

/**
 * Returns responses for Hover Card routes.
 */
class HoverCardController extends ControllerBase {

  /**
   * Constructs a HoverCardController object.
   */
  public function __construct(
    protected RendererInterface $renderer,
    protected HoverCardDataService $hoverCardDataService,
  ) {}

  /**
   * {@inheritdoc}
   */
  public static function create(ContainerInterface $container): static {
    return new static(
      $container->get('renderer'),
      $container->get('hover_card.data_service')
    );
  }

  /**
   * Builds the response.
   *
   * @param \Drupal\user\UserInterface $user
   *   The user object.
   *
   * @return \Symfony\Component\HttpFoundation\Response
   *   The user data response.
   */
  public function build(UserInterface $user): Response {
    // Get user data from the service.
    $user_data = $this->hoverCardDataService->getUserData($user);

    // Build the render array.
    $hover_card_template_build = [
      '#theme' => 'hover_card',
      '#details' => $user_data,
    ];

    // Render and return response.
    $response = new Response();
    $response->setContent($this->renderer->renderInIsolation($hover_card_template_build));
    return $response;
  }

}
