<?php

namespace Drupal\Tests\hover_card\Kernel;

use Drupal\KernelTests\KernelTestBase;
use Drupal\user\Entity\User;

/**
 * Kernel tests for HoverCardController.
 *
 * @group hover_card
 */
class HoverCardControllerTest extends KernelTestBase {

  /**
   * {@inheritdoc}
   */
  protected static $modules = [
    'system',
    'user',
    'hover_card',
  ];

  /**
   * {@inheritdoc}
   */
  protected function setUp(): void {
    parent::setUp();

    $this->installEntitySchema('user');
    $this->installConfig(['hover_card']);
  }

  /**
   * Tests controller build method returns response.
   */
  public function testControllerBuild() {
    $user = User::create([
      'name' => 'test_user',
      'mail' => 'test@example.com',
      'status' => 1,
    ]);
    $user->save();

    $controller = $this->container->get('hover_card.controller');
    $response = $controller->build($user);

    $this->assertInstanceOf('\Symfony\Component\HttpFoundation\Response', $response);
    $content = $response->getContent();
    $this->assertNotEmpty($content);
    $this->assertStringContainsString('test_user', $content);
  }

  /**
   * Tests hover card data service integration.
   */
  public function testDataServiceIntegration() {
    $user = User::create([
      'name' => 'test_user_2',
      'mail' => 'test2@example.com',
      'status' => 1,
    ]);
    $user->save();

    $service = $this->container->get('hover_card.data_service');
    $data = $service->getUserData($user);

    $this->assertIsArray($data);
    $this->assertArrayHasKey('name', $data);
    $this->assertEquals('test_user_2', $data['name']);
  }

}
