<?php

namespace Drupal\Tests\hover_speech\Kernel;

use Drupal\KernelTests\KernelTestBase;

/**
 * Tests the Hover Speech configuration.
 *
 * @group hover_speech
 */
class HoverSpeechConfigTest extends KernelTestBase {

  /**
   * {@inheritdoc}
   */
  protected static $modules = [
    'system',
    'user',
    'hover_speech',
  ];

  /**
   * Tests default config values.
   */
  public function testDefaultConfigValues(): void {
    $config = $this->config('hover_speech.settings');

    $this->assertEquals('auto', $config->get('language_mode'));
    $this->assertEquals('#28a745', $config->get('background_color'));
    $this->assertEquals('#ffffff', $config->get('text_color'));
    $this->assertEquals('#1e7e34', $config->get('border_color'));
    $this->assertEquals('#218838', $config->get('hover_color'));
    $this->assertEquals('rounded', $config->get('button_shape'));
    $this->assertEquals('bottom-right', $config->get('button_position'));
    $this->assertEquals(14, $config->get('button_font_size'));
  }

  /**
   * Tests saving config values.
   */
  public function testSaveConfigValues(): void {
    $this->config('hover_speech.settings')
      ->set('language_mode', 'english')
      ->set('background_color', '#000000')
      ->set('text_color', '#ff0000')
      ->set('border_color', '#00ff00')
      ->set('hover_color', '#0000ff')
      ->set('button_shape', 'circle')
      ->set('button_position', 'top-left')
      ->set('button_font_size', 20)
      ->save();

    $config = $this->config('hover_speech.settings');

    $this->assertEquals('english', $config->get('language_mode'));
    $this->assertEquals('#000000', $config->get('background_color'));
    $this->assertEquals('#ff0000', $config->get('text_color'));
    $this->assertEquals('#00ff00', $config->get('border_color'));
    $this->assertEquals('#0000ff', $config->get('hover_color'));
    $this->assertEquals('circle', $config->get('button_shape'));
    $this->assertEquals('top-left', $config->get('button_position'));
    $this->assertEquals(20, $config->get('button_font_size'));
  }

}
