(function ($, Drupal, once) {
  Drupal.behaviors.hoverSpeech = {
    attach: function (context, settings) {
      const synth = window.speechSynthesis;
      let speechEnabled = false;

      const config = settings.hover_speech || {};
      const buttonSelector = '#speechToggleBtn';
      const label = $('#speechToggleLabel', context);
      const button = $(buttonSelector, context);

      // ================== Styling ==================
      button.css({
        'background-color': config.background_color,
        'color': config.text_color,
        'border': `2px solid ${config.border_color}`,
        'padding': '6px 12px',
        'cursor': 'pointer',
        'position': 'fixed',
        'z-index': '9999',
        'transition': 'all 0.3s ease',
        'font-size': config.button_font_size + 'px',
      });

      // Shape
      switch (config.button_shape) {
        case 'circle':
          button.css('border-radius', '50%');
          break;
        case 'square':
          button.css('border-radius', '0');
          break;
        default:
          button.css('border-radius', '8px');
      }

      // Position
      switch (config.button_position) {
        case 'top-left':
          button.css({ top: '20px', left: '20px' });
          break;
        case 'top-right':
          button.css({ top: '20px', right: '20px' });
          break;
        case 'bottom-left':
          button.css({ bottom: '20px', left: '20px' });
          break;
        default:
          button.css({ bottom: '20px', right: '20px' });
      }

      // Hover effect
      button.hover(
        function () {
          $(this).css('background-color', config.hover_color);
        },
        function () {
          $(this).css('background-color', config.background_color);
        }
      );

      // ================== Toggle ==================
      label.html('<span class="speaker-icon">🔇</span> Speech OFF');

      once('speech-toggle', buttonSelector, context).forEach((el) => {
        $(el).on('click', function () {
          speechEnabled = !speechEnabled;
          if (speechEnabled) {
            label.html('<span class="speaker-icon">🔊</span> Speech ON');
            speakText("Speech On");
          } else {
            label.html('<span class="speaker-icon">🔇</span> Speech OFF');
            speakText("Speech Off");
            synth.cancel();
          }
        });
      });

      // ================== Hover Speech ==================
      const tags = "p, span, div, li, a, h1, h2, h3, h4, h5, h6, img";
      once('hover-speech', tags, context).forEach((el) => {
        $(el).hover(
          function () {
            if (!speechEnabled) return;

            let text = $(this).text().trim();

            // Special cases: img alt/title or link titles
            if (!text) {
              if ($(this).is('img')) {
                text = $(this).attr('alt') || $(this).attr('title') || '';
              } else {
                text = $(this).attr('title') || $(this).find('img').attr('alt') || '';
              }
            }

            if (text) {
              speakText(text);
            }
          },
          function () {
            if (speechEnabled) synth.cancel();
          }
        );
      });

      // ================== Font Resize Controls ==================
      if ($('#increaseFontBtn', context).length && $('#decreaseFontBtn', context).length) {
        let currentFontSize = config.button_font_size || 14;
        const step = config.font_step || 2;

        $('#increaseFontBtn', context).on('click', function () {
          currentFontSize += step;
          button.css('font-size', currentFontSize + 'px');
          label.css('font-size', currentFontSize + 'px');
        });

        $('#decreaseFontBtn', context).on('click', function () {
          if (currentFontSize > step) {
            currentFontSize -= step;
            button.css('font-size', currentFontSize + 'px');
            label.css('font-size', currentFontSize + 'px');
          }
        });
      }

      // ================== Speak Helper ==================
      function speakText(text) {
        if (!text) return;
        synth.cancel();
        const utterance = new SpeechSynthesisUtterance(text);
        synth.speak(utterance);
      }
    }
  };
})(jQuery, Drupal, once);
