# HTML Lang Attribute Override

The **HTML Lang Attribute Override** module allows site administrators to explicitly
control the `lang` attribute of the `<html>` tag globally or on per-page basis.
It’s ideal for websites that have a few pages in different languages but do not
require Drupal’s full multilingual capabilities.

For a full description of the module, visit the
[project page](https://www.drupal.org/project/html_lang_override).

Submit bug reports and feature suggestions, or track changes in the
[issue queue](https://www.drupal.org/project/issues/search/html_lang_override).

## Why Use This Module?

In cases where only a few pages are written in languages other than the site's
default language — and the multilingual module is not used — this module
provides a lightweight way to ensure the correct HTML `lang` attribute is set
for those pages.

It also helps address SEO warnings related to `hreflang` mismatches, ensuring
the language declared in the HTML tag matches the expected language of the page.

## Features

- Set a global default `lang` attribute for the entire site.
- Override the `lang` attribute per node (via the node edit form).
- Set language codes per path (views, controllers, etc.).
- Prevent SEO warnings due to mismatched HTML language declarations.

## Installation

Install as you would normally install a contributed Drupal module. For further
information, see
[Installing Drupal Modules](https://www.drupal.org/docs/extending-drupal/installing-drupal-modules).

## Configuration

After installing the module, visit the configuration form to manage settings:
`/admin/config/regional/html-lang-override`

From this screen, users with the appropriate permissions can:
- Set the global default HTML `lang` code.
- Enable or disable the override feature.
- Set custom language codes for specific paths (e.g., `/about-us`, `/contact`).

## Per-Node Override

For content types (nodes), a new field appears under the "Advanced" section of
the node edit form (if the user has the right permission). This allows editors
to override the language code for individual content pages.
