# HTMX: A Third-Party Asset to Drupal

## Introduction

The main htmx library is not provided by Drupal core.

### Source

The HTMX project collaborates and distributes via [https://github.com/bigskysoftware/htmx](https://github.com/bigskysoftware/htmx)

## SHA384 Sums

The SHA384 reduced to base64 for debug.js is

cspell:disable
`RNXAU1D9now8hhHW/KcRwHAFwc76r0Mne6FNQvkvrznHaeJpW+Qd1S5nBRoCavje`
cspell:enable

This sum can be [replicated and verified](https://www.srihash.org/) on the
command line:

```shell
openssl dgst -sha384 -binary js/htmx/debug.js | openssl base64 -A
```


## Update debug.js instructions:

Copy, compare and update the the debug extension with our copy.  This
extension is not minified.  The current version is at:

[https://github.com/bigskysoftware/htmx-extensions/tree/main/src/debug](https://github.com/bigskysoftware/htmx-extensions/tree/main/src/debug)
