<?php

declare(strict_types=1);

namespace Drupal\htmx\Controller;

use Drupal\Core\Controller\ControllerBase;

/**
 * Returns responses for htmx routes.
 */
final class ToolbarOnlyController extends ControllerBase {

  /**
   * Builds the response.
   */
  public function __invoke(): array {

    $build['content'] = [
      '#type' => 'item',
      '#markup' => $this->t('This display is provided in case the toolbar itself is needed as a content source.'),
    ];

    return $build;
  }

}
