<?php

declare(strict_types=1);

namespace Drupal\Tests\htmx\Functional;

use Drupal\Tests\BrowserTestBase;
use Drupal\user\UserInterface;

/**
 * Tests the HTMX Debug module functionality.
 *
 * @group htmx
 */
final class HtmxDebugTest extends BrowserTestBase {

  /**
   * {@inheritdoc}
   */
  protected $defaultTheme = 'stark';

  /**
   * {@inheritdoc}
   */
  protected static $modules = ['block', 'htmx', 'htmx_debug'];

  /**
   * Admin user.
   */
  protected UserInterface $adminUser;

  /**
   * {@inheritdoc}
   */
  protected function setUp(): void {
    parent::setUp();
    $this->adminUser = $this->drupalCreateUser(['access administration pages', 'administer htmx_block']);
  }

  /**
   * Tests that the debug extension is properly loaded.
   */
  public function testDebugExtensionLoading(): void {
    $this->drupalLogin($this->adminUser);
    // Visit the htmx block page.
    $this->drupalGet('/admin/structure/htmx-block');

    // Check that the debug extension is enabled via a data attribute.
    $this->assertSession()->elementAttributeContains('css', 'body', 'data-hx-ext', 'debug');

    // Check that the debug library is attached.
    $this->assertSession()->responseContains('htmx/debug.js');
  }

  /**
   * Tests that the debug module correctly modifies the htmx library.
   */
  public function testHtmxLibraryModification(): void {
    $this->drupalLogin($this->adminUser);
    // Visit the front page.
    $this->drupalGet('/admin/structure/htmx-block');

    // Check that the non-minified version of htmx is loaded
    // instead of the minified one.
    $this->assertSession()->responseContains('htmx.js');
    $this->assertSession()->responseNotContains('htmx.min.js');
  }

}
