// The javascript that creates dropbuttons is not present on the /page at
// initial load.  If the once data property is added then the JS was loaded
// and triggered on the inserted content.
module.exports = {
  '@tags': ['htmx'],
  before(browser) {
    browser
      .drupalInstall({
        setupFile: `${__dirname}/../HtmxToolbarLoadTestSetup.php`
      })
  },
  afterEach(browser) {
    browser.drupalLogAndEnd({ onlyOnError: true });
  },
  after(browser) {
    browser.drupalUninstall();
  },
  'Toolbar Not Present': browser => {
    browser.drupalRelativeURL('/htmx-test-attachments/page')
      .waitForElementVisible('body', 1000)
      .waitForElementVisible('button[name="replace"]', 1000)
      .click('button[name="replace"]')
      .waitForElementVisible('div.dropbutton-wrapper', 60000)
      .waitForElementVisible('div[data-once="dropbutton"]', 60000)
      .element.find('p[data-toolbar-detector]').getText().assert.contains('Toolbar not in response')
  },
  'Toolbar Requested': browser => {
    browser.drupalRelativeURL('/htmx-test-attachments/toolbar')
      .waitForElementVisible('body', 1000)
      .waitForElementVisible('button[name="toolbar"]', 1000)
      .click('button[name="toolbar"]')
      .waitForElementVisible('p[data-toolbar-detector]', 60000)
      .element.find('p[data-toolbar-detector]').getText().assert.contains('Toolbar in response')
  }
};
