module.exports = {
  '@tags': ['htmx'],
  before(browser) {
    browser
      .drupalInstall({
        setupFile: `${__dirname}/../HtmxBlockPlacementTestSetup.php`
      })
  },
  afterEach(browser) {
    browser.drupalLogAndEnd({ onlyOnError: false });
  },
  after(browser) {
    browser.drupalUninstall();
  },
  'Dynamic Block': browser => {
    browser
      .drupalRelativeURL('/htmx-test-attachments/page')
      .waitForElementVisible('body', 1000)
      .waitForElementVisible('#block-olivero-htmx-demo', 1000)
      .waitForElementVisible('button.button', 1000)
      .click('button.button')
      .waitForElementVisible('#block-htmx-test-block', 60000)
      .assert.textContains('#block-htmx-test-block', 'Inserted by HTMX!');
    // Capture the random marker.
    const firstMarker = browser.element('.htmx-test-marker').getText();
    browser.drupalRelativeURL('/htmx-test-attachments/two')
      .waitForElementVisible('body', 1000)
      .waitForElementVisible('#block-olivero-htmx-demo', 1000)
      .waitForElementVisible('button.button', 1000)
      .click('button.button')
      .waitForElementVisible('#block-htmx-test-block', 60000)
      .assert.textContains('#block-htmx-test-block', 'Inserted by HTMX!')
      .assert.not.textEquals('.htmx-test-marker', firstMarker);
  },
};
