<?php

namespace Drupal\htmx\Template;

use Drupal\Core\Htmx\Htmx;

/**
 * This class leverages the Htmx class to build htmx attributes for Twig.
 *
 * Attribute related methods are re-presented here from the Htmx class.
 */
class HtmxAttributeBuilder implements \Stringable {

  /**
   * Builder for htmx attributes.
   */
  protected Htmx $htmx;

  public function __construct() {
    $this->htmx = new Htmx();
  }

  /**
   * {@inheritdoc}
   */
  public function __toString(): string {
    return $this->htmx->getAttributes()->__toString();
  }

  /**
   * Proxy all HTMX methods to the Htmx class.
   *
   * Note that header methods will have no effect when this class is cast
   * to a string.
   */
  public function __call(string $name, array $arguments): static {
    $this->htmx->$name(...$arguments);
    return $this;
  }

}
