<?php

declare(strict_types=1);

namespace Drupal\htmx_test_attachments\Controller;

use Drupal\Core\Controller\ControllerBase;
use Drupal\Core\Htmx\Htmx;
use Drupal\Core\Template\Attribute;
use Drupal\Core\Url;

/**
 * Returns responses for HTMX Test Attachments routes.
 */
final class HtmxTestAttachmentsController extends ControllerBase {

  /**
   * Builds the response.
   *
   * @return mixed[]
   *   A render array.
   */
  public function page(): array {
    $buttonAttributes = new Attribute(['class' => ['button'], 'name' => 'replace']);
    $htmx = new Htmx();
    $htmx->get(Url::fromRoute('htmx_test_attachments.replace'))
      ->select('div.dropbutton-wrapper')
      ->target('closest div')
      ->swap('beforeend');
    $build['content'] = [
      '#type' => 'container',
      '#attached' => [
        'library' => [
          'htmx/drupal',
          'htmx_test_attachments/toolbar',
        ],
      ],
      'button' => [
        '#type' => 'inline_template',
        '#template' => '<button {{ attributes }}>Click this</button>',
        '#context' => [
          'attributes' => $buttonAttributes->merge($htmx->getAttributes()),
        ],
      ],
    ];

    return $build;
  }

  /**
   * Builds the HTMX response.
   *
   * @return mixed[]
   *   A render array.
   */
  public function replace(): array {
    $build['content'] = [
      '#type' => 'dropbutton',
      '#dropbutton_type' => 'small',
      '#links' => [
        'simple_form' => [
          'title' => $this->t('Sample link 1'),
          'url' => Url::fromRoute('system.timezone'),
        ],
        'demo' => [
          'title' => $this->t('Sample link 2'),
          'url' => Url::fromRoute('<front>'),
        ],
      ],
    ];

    return $build;
  }

}
