<?php

declare(strict_types=1);

namespace Drupal\htmx_dialog\Controller;

use Drupal\htmx\Controller\HtmxEntityViewController;
use Drupal\Core\Entity\EntityInterface;
/**
 * Returns an entity rendered in a view mode.
 */
class HtmxDialogEntityViewController extends HtmxEntityViewController {

  /**
   * Builds the response.
   *
   * @param string $entityType
   *   The id of the entity type requested.
   * @param \Drupal\Core\Entity\EntityInterface $entity
   *   The entity upcast from the entity id in the request path.
   * @param string $viewMode
   *   The view mode to use in rendering the entity.
   *
   * @return mixed[]
   *   The render array.
   */
  public function view(string $entityType, EntityInterface $entity, string $viewMode = 'default'): array {
    $build = [];
    $entity_view = parent::view($entityType, $entity, $viewMode);
    $build['dialog'] = [
      '#type' => 'component',
      '#component' => 'htmx_dialog:htmx-dialog',
      '#slots' => [
        'content' => $entity_view,
      ],
    ];
    return $build;
  }

}
