<?php

namespace Drupal\htmx_extras\Hook;

use Drupal\Core\Hook\Attribute\Hook;

class ThemeSuggestions {

  #[Hook('theme_suggestions_htmx_entity_partial_alter')]
  public function alterEntity(array &$suggestions, array $variables): void {
    if (isset($variables['entity_type'])) {
      $suggestions[] = 'htmx_entity_partial'
        . '__' . $variables['entity_type'];

      if (isset($variables['view_mode'])) {
        $suggestions[] = 'htmx_entity_partial'
          . '__' . $variables['entity_type']
          . '__' . $variables['view_mode'];
      }

      if (isset($variables['bundle'])) {
        $suggestions[] = 'htmx_entity_partial'
          . '__' . $variables['entity_type']
          . '__' . $variables['bundle'];

        if (isset($variables['view_mode'])) {
          $suggestions[] = 'htmx_entity_partial'
            . '__' . $variables['entity_type']
            . '__' . $variables['bundle']
            . '__' . $variables['view_mode'];
        }
      }
    }
  }

  #[Hook('theme_suggestions_htmx_route_partial_alter')]
  public function alterRoute(array &$suggestions, array $variables): void {
    if (!empty($variables['route_name'])) {
      $clean_route_name = preg_replace('/[^a-z0-9_]/', '__', $variables['route_name']);
      $suggestions[] = 'htmx_route_partial' . '__' . $clean_route_name;
    }
  }

}
