<?php

namespace Drupal\htmx_extras;

final readonly class HtmxExtrasHelper {

  public static function availableAttributes(bool $with_prefix = TRUE): array {
    $attributes = [
      'get',
      'post',
      'push-url',
      'select',
      'select-oob',
      'swap',
      'swap-oob',
      'trigger',
      'vals',
      'boost',
      'confirm',
      'delete',
      'disable',
      'disabled-elt',
      'disinherit',
      'encoding',
      'ext',
      'headers',
      'history',
      'indicator',
      'inherit',
      'params',
      'patch',
      'preserve',
      'prompt',
      'put',
      'replace-url',
      'request',
      'sync',
      'validate',
      'vars',
    ];

    if ($with_prefix) {
      $attributes = array_map(static fn ($attribute) => 'data-hx-' . $attribute, $attributes);
    }
    return $attributes;
  }

}
