<?php

namespace Drupal\htmx_extras\Hook;

use Drupal\Core\Hook\Attribute\Hook;

class Theme {

  #[Hook('theme')]
  public function hook(): array {
    $themes['htmx_entity_partial'] = [
      'variables' => [
        'entity_type' => '',
        'entity_id' => '',
        'bundle' => '',
        'view_mode' => '',
        'revision_id' => NULL,
        'options' => [],
        'extra_htmx_attributes' => [
          'data-hx-trigger' => 'revealed',
          'data-hx-swap' => 'outerHTML',
        ],
      ],
    ];
    $themes['htmx_route_partial'] = [
      'variables' => [
        'route_name' => '',
        'route_parameters' => [],
        'route_options' => [],
        'extra_htmx_attributes' => [
          'data-hx-trigger' => 'revealed',
          'data-hx-swap' => 'outerHTML',
        ],
      ],
    ];
    return $themes;
  }

}
