<?php

namespace Drupal\htmx_extras\Plugin\Block;

use Drupal\Core\Block\Attribute\Block;
use Drupal\Core\StringTranslation\TranslatableMarkup;
use Drupal\htmx_extras\Plugin\Derivative\HtmxViewBlock as HtmxViewBlockDeriver;

/**
 * Provides a generic Views block.
 */
#[Block(
  id: "htmx_view_block",
  admin_label: new TranslatableMarkup("HTMX View Block"),
  deriver: HtmxViewBlockDeriver::class
)]
class HtmxViewBlock extends HtmxViewBlockBase {

  /**
   * {@inheritdoc}
   */
  public function build() {
    return [
      'htmx_view' => $this->htmxView->render(),
    ];
  }

  /**
   * {@inheritdoc}
   */
  public function getMachineNameSuggestion() {
    return 'htmx_view_block__' . $this->htmxView->id();
  }

}
