<?php

namespace Drupal\htmx_extras\Routing;

use Drupal\Core\Routing\RouteSubscriberBase;
use Drupal\htmx_extras\Entity\HtmxView;
use Drupal\htmx_extras\HtmxViewInterface;
use Symfony\Component\Routing\Route;
use Symfony\Component\Routing\RouteCollection;

final class RouteSubscriber extends RouteSubscriberBase {

  /**
   * {@inheritDoc}
   */
  protected function alterRoutes(RouteCollection $collection): void {
    $htmx_views = HtmxView::loadMultiple();
    $htmx_views = array_filter($htmx_views, function (HtmxViewInterface $htmx_view) {
      return $htmx_view->status() && $htmx_view->getViewType() === 'page';
    });

    // Add views as routes.
    foreach ($htmx_views as $htmx_view) {
      $route = new Route(
        path: $htmx_view->getPath(),
        defaults: [
          '_controller' => '\Drupal\htmx_extras\Controller\LazyLoadController::view',
          '_title' => $htmx_view->getTitle(),
          'htmx_view' => $htmx_view->id(),
        ],
        requirements: [
          '_entity_access' => 'htmx_view.view',
        ],
        options: [
          'parameters' => [
            'htmx_view' => [
              'type' => 'entity:htmx_view',
            ],
          ],
        ],
      );


      $collection->add("htmx_extras.htmx_view.{$htmx_view->id()}", $route);
    }
  }

}
