<?php

namespace Drupal\htmx_extras\Hook;

use Drupal\Core\Hook\Attribute\Hook;

class Theme {

  #[Hook('theme')]
  public function hook(): array {
    $templates = [
      'htmx_entity_partial' => [
        'variables' => [
          'entity_type' => '',
          'entity_id' => '',
          'bundle' => '',
          'view_mode' => '',
          'revision_id' => NULL,
          'options' => [],
          'extra_htmx_attributes' => [
            'data-hx-trigger' => 'revealed',
            'data-hx-swap' => 'outerHTML',
          ],
        ],
      ],
      'htmx_route_partial' => [
        'variables' => [
          'route_name' => '',
          'route_parameters' => [],
          'route_options' => [],
          'extra_htmx_attributes' => [
            'data-hx-trigger' => 'revealed',
            'data-hx-swap' => 'outerHTML',
          ],
        ],
      ],
      'htmx_view_view' => [
        'variables' => [
          'htmx_view' => NULL,
          'view_id' => '',
          'display_id' => '',
          'items' => [],
          'pager' => [],
          'facet_summary' => '',
          'facets' => [],
          'attributes' => [],
        ],
      ],
      'htmx_view_pager' => [
        'variables' => [
          'htmx_view' => '',
          'definition' => [],
          'extra_htmx_attributes' => [],
          'filtered_rest_route_name' => '',
          'filtered_rest_route_parameters' => [],
          'filtered_rest_route_options' => [],
          'history_push_url' => '',
          'current_page' => 0,
          'total_pages' => '',
          'total_items' => '',
          'htmx_view_wrapper_id' => '',
          'attributes' => [],
        ],
      ],
      'htmx_view_facet' => [
        'variables' => [
          'extra_htmx_attributes' => [],
          'facet_config' => [],
          'htmx_view' => '',
          'label' => '',
          'weight' => '',
          'facet_id' => '',
          'field_id' => '',
          'url_alias' => '',
          'items' => [],
        ],
      ],
      'htmx_view_facet_summary' => [
        'variables' => [
          'extra_htmx_attributes' => [],
          'htmx_view' => '',
          'items' => [],
        ],
      ],
    ];

    foreach (['full', 'mini', 'load_more', 'infinite_scroll'] as $pager_type) {
      $templates["htmx_view_pager__$pager_type"] = [
        'base hook' => 'htmx_view_pager',
      ];
    }

    return $templates;
  }

}
