<?php

declare(strict_types=1);

namespace Drupal\htmx_extras;

use Drupal\Core\Config\Entity\ConfigEntityListBuilder;
use Drupal\Core\Entity\EntityInterface;
use Drupal\Core\Url;

/**
 * Provides a listing of htmx views.
 */
final class HtmxViewListBuilder extends ConfigEntityListBuilder {

  /**
   * {@inheritdoc}
   */
  public function buildHeader(): array {
    $header['label'] = $this->t('Label');
    $header['id'] = $this->t('Machine name');
    $header['status'] = $this->t('Status');
    return $header + parent::buildHeader();
  }

  /**
   * {@inheritdoc}
   */
  public function buildRow(EntityInterface $entity): array {
    /** @var \Drupal\htmx_extras\HtmxViewInterface $entity */
    $row['label'] = $entity->label();
    $row['id'] = $entity->id();
    $row['status'] = $entity->status() ? $this->t('Enabled') : $this->t('Disabled');
    return $row + parent::buildRow($entity);
  }

  /**
   * {@inheritDoc}
   */
  public function getDefaultOperations(EntityInterface $entity): array {
    /** @var \Drupal\htmx_extras\HtmxViewInterface $entity */
    $operations = parent::getDefaultOperations($entity);

    if ($entity->getViewType() === 'page') {
      try {
        $operations['view'] = [
          'title' => $this->t('View'),
          'weight' => 5,
          'url' => Url::fromRoute("htmx_extras.htmx_view.{$entity->id()}"),
        ];
      }
      catch (\Exception $e) {
        // Do nothing, the router cache probably didn't flush yet.
      }
    }

    return $operations;
  }

}
