# HTMX Extras

The HTMX Extras module adds some lazy loading functionality to your website.

Currently, these elements are implemented:

* Lazy load entity: A template to lazily load an entity render
* Lazy load route: A template to lazily load the contents of a given route
* Search API lazy load row plugin: Renders your views lazily when they're revealed in the viewport (completely customizable, uses the "Lazy load entity"-template)
* HTMX-powered views (see more below the examples)

More functionality will be added once the need arises, feel free to create a ticket if you have a use case that could fall under this module's scope.

For replacing Drupal's AJAX API with HTMX, we gladly refer to the excellent HTMX-project

## Examples:

### Entity

```php
use Drupal\htmx_extras\Render\HtmxEntityPartial;

// ...

// From plain parameters:
$build = HtmxEntityPartial::fromParameters($entity_type, $entity_id)
->setViewMode($view_mode)
->setOption('language', $language)
->setHtmxParameter('trigger', 'intersect once')
->render();

// From an entity object, note that the language parameter is derived from the entity object and does not need to be set manually:
$build = HtmxEntityPartial::fromEntity($entity)
->setViewMode($view_mode)
->setHtmxParameter('trigger', 'load')
->render();
```

### Route

```php
use Drupal\htmx_extras\Render\HtmxRoutePartial;

// ...

$build = HtmxRoutePartial::fromRoute('my_module.route_name', ['parameter1' => 'value1'], ['language' => $language])
->setHtmxParameter('trigger', 'load')
->render();
```

## HTMX-powered views

In 1.0.4, a big new feature called "HTMX views" was added.
This allows the webmaster to add a view that rivals the reactivity of full blown react apps, but with almost fully Drupal core-powered technologies.
It does use AlpineJS for small pieces (mainly updating the URL history in the browser).

This patch is needed for the pager to work properly: https://www.drupal.org/project/facets/issues/3008615

**Full steps:**

1. Add a REST Export-display to your desired view
2. Make sure to use the "Facets serializer"-display format and after applying the patch above, turn on "Display pager and results"
3. Make sure to use 'fields' and only add the "Item ID"-search API field, and in the fields settings (under format) give it the alias, e.g. "id".
4. Use the "Full"-pager and configure however many items per page you'd like to see
5. Configure your view as necessary (filters, sorts, ..) but use normal facets (not the new views exposed facets from facets 3.x, these are currently not yet supported).
6. Go to /admin/structure/htmx-view and create a new HTMX view
7. Configure it as you'd like, remember to use the "id"-alias in the "Item ID"-field mapping
