<?php

declare(strict_types=1);

namespace Drupal\htmx_extras\Form;

use Drupal\Core\Entity\EntityInterface;
use Drupal\Core\Form\FormStateInterface;

/**
 * HTMX View duplicate form.
 */
class HtmxViewDuplicateForm extends HtmxViewForm {

  public function setEntity(EntityInterface $entity) {
    $entity = $entity->createDuplicate();
    $entity->label = $entity->label() . ' - ' . $this->t('duplicate');
    return parent::setEntity($entity);
  }

}
