<?php

namespace Drupal\htmx_extras\Hook;

use Drupal\Core\Hook\Attribute\Hook;

class ThemeSuggestions {

  #[Hook('theme_suggestions_htmx_entity_partial_alter')]
  public function entityPartial(array &$suggestions, array $variables): void {
    if (isset($variables['entity_type'])) {
      $suggestions[] = 'htmx_entity_partial'
        . '__' . $variables['entity_type'];

      if (isset($variables['view_mode'])) {
        $suggestions[] = 'htmx_entity_partial'
          . '__' . $variables['entity_type']
          . '__' . $variables['view_mode'];
      }

      if (isset($variables['bundle'])) {
        $suggestions[] = 'htmx_entity_partial'
          . '__' . $variables['entity_type']
          . '__' . $variables['bundle'];

        if (isset($variables['view_mode'])) {
          $suggestions[] = 'htmx_entity_partial'
            . '__' . $variables['entity_type']
            . '__' . $variables['bundle']
            . '__' . $variables['view_mode'];
        }
      }
    }
  }

  #[Hook('theme_suggestions_htmx_route_partial_alter')]
  public function routePartial(array &$suggestions, array $variables): void {
    if (!empty($variables['route_name'])) {
      $clean_route_name = preg_replace('/[^a-z0-9_]/', '__', $variables['route_name']);
      $suggestions[] = 'htmx_route_partial' . '__' . $clean_route_name;
    }
  }

  #[Hook('theme_suggestions_htmx_view_view_alter')]
  public function view(array &$suggestions, array $variables): void {
    /** @var \Drupal\htmx_extras\HtmxViewInterface $htmx_view */
    if (isset($variables['htmx_view']) && ($htmx_view = $variables['htmx_view'])) {
      $suggestions[] = 'htmx_view_view' . '__' . $htmx_view->id();
    }
  }

  #[Hook('theme_suggestions_htmx_view_pager_alter')]
  public function pager(array &$suggestions, array $variables): void {
    if (isset($variables['definition']['type']) && ($pager_type = $variables['definition']['type'])) {
      $suggestions[] = 'htmx_view_pager' . '__' . $pager_type;

      if (isset($variables['htmx_view']) && ($htmx_view = $variables['htmx_view'])) {
        $suggestions[] = 'htmx_view_pager' . '__' .  $htmx_view. '__' . $pager_type;
      }
    }
  }

  #[Hook('theme_suggestions_htmx_view_facet_alter')]
  public function facet(array &$suggestions, array $variables): void {
    if (isset($variables['facet_id']) && ($facet_id = $variables['facet_id'])) {
      $suggestions[] = 'htmx_view_facet' . '__' . $facet_id;

      if (isset($variables['htmx_view']) && ($htmx_view = $variables['htmx_view'])) {
        $suggestions[] = 'htmx_view_facet' . '__' .  $htmx_view . '__' . $facet_id;
      }
    }
  }

  #[Hook('theme_suggestions_htmx_view_facet_summary_alter')]
  public function facetSummary(array &$suggestions, array $variables): void {
    if (isset($variables['htmx_view']) && ($htmx_view = $variables['htmx_view'])) {
      $suggestions[] = 'htmx_view_facet_summary' . '__' .  $htmx_view;
    }
  }

}
