<?php

namespace Drupal\htmx_extras;

final readonly class HtmxExtrasHelper {

  public static function availableAttributes(bool $with_prefix = TRUE): array {
    $attributes = [
      'boost',
      'confirm',
      'delete',
      'disable',
      'disabled-elt',
      'disinherit',
      'encoding',
      'ext',
      'get',
      'headers',
      'history',
      'indicator',
      'inherit',
      'params',
      'patch',
      'post',
      'preserve',
      'prompt',
      'push-url',
      'put',
      'replace-url',
      'request',
      'select',
      'select-oob',
      'swap',
      'swap-oob',
      'sync',
      'trigger',
      'validate',
      'vals',
      'vars',
    ];

    if ($with_prefix) {
      $attributes = array_map(static fn ($attribute) => 'data-hx-' . $attribute, $attributes);
    }
    return $attributes;
  }

}
