<?php

declare(strict_types=1);

namespace Drupal\htmx_extras;

use Drupal\Core\Config\Entity\ConfigEntityInterface;
use Drupal\views\ViewExecutable;

/**
 * Provides an interface defining a htmx view entity type.
 */
interface HtmxViewInterface extends ConfigEntityInterface {

  public function getViewSource(): ?ViewExecutable;

  public function getMappedKey(string $key): ?string;

  public function getMappedKeys(): array;

  public function getEntityViewMode(): ?string;

  public function getViewType(): ?string;

  public function getTitle(): ?string;

  public function getPath(): ?string;

  public function getPagerDefinition(): ?array;

  public function getFacetsConfiguration(): ?array;

  public function showFacets(): bool;

  public function showFacetSummary(): bool;

  public function getLazyLoadAll(): bool;

  public function getLazyLoadAllSettings(): array;

  public function render(): ?array;

}
