<?php

namespace Drupal\htmx_extras\TwigExtension;

use Drupal\htmx_extras\Entity\HtmxView;
use Twig\Extension\AbstractExtension;
use Twig\TwigFunction;

final class HtmxViewTwigExtension extends AbstractExtension {

  /**
   * {@inheritDoc}
   */
  public function getFunctions(): array {
    return [
      new TwigFunction('htmx_view',
        [$this, 'renderHtmxView'],
        ['is_safe' => ['html']],
      ),
    ];
  }

  public function renderHtmxView(string $htmx_view_id): ?array {
    if (!$htmx_view_id) {
      return NULL;
    }

    return HtmxView::load($htmx_view_id)?->render();
  }

}
