<?php

namespace Drupal\http_client_log;

use Drupal\Component\Datetime\TimeInterface;
use Drupal\Core\Config\ConfigFactoryInterface;
use Drupal\Core\Entity\EntityTypeManagerInterface;
use Drupal\Core\Http\ClientFactory;
use Drupal\http_client_log\Logger\Logger;
use GuzzleHttp\HandlerStack;
use GuzzleHttp\TransferStats;
use GuzzleLogMiddleware\Handler\HandlerInterface;
use GuzzleLogMiddleware\LogMiddleware;
use Psr\Http\Message\RequestInterface;
use Psr\Http\Message\ResponseInterface;
use Psr\Log\LoggerInterface;

/**
 * Define HttpClientLogService class.
 */
class HttpClientLogService extends ClientFactory {

  /**
   * {@inheritdoc}
   */
  public function __construct(
    HandlerStack $stack,
    EntityTypeManagerInterface $entity_type_manager,
    ConfigFactoryInterface $config_factory,
    TimeInterface $time,
  ) {
    parent::__construct($stack);
    $logger = new Logger(
      $entity_type_manager,
      $config_factory,
      $time,
    );
    $this->stack->push(new LogMiddleware($logger, new SimpleHandler()));
  }

}

/**
 * A simple handler that logs only requests and response .*/
final class SimpleHandler implements HandlerInterface {

  /**
   * {@inheritdoc}
   */
  public function log(
    LoggerInterface $logger,
    RequestInterface $request,
    ?ResponseInterface $response = NULL,
    ?\Throwable $exception = NULL,
    ?TransferStats $stats = NULL,
    array $options = [],
  ): void {
    $context['request'] = $request;
    $context['response'] = $response;
    $context['options'] = $options;
    $logger->log(NULL, NULL, $context);
  }

}
