<?php

declare(strict_types=1);

namespace Drupal\http_headers\Controller;

use Drupal\Core\DependencyInjection\ContainerInjectionInterface;
use Symfony\Component\HttpFoundation\Request;
use Drupal\Core\Controller\ControllerBase;

/**
 * General form handling in Joyspeed.
 */
class HttpHeaders extends ControllerBase implements ContainerInjectionInterface {

  /**
   * List all HTTP request headers.
   *
   * @return array<string, mixed>
   *   Return a render array with a table of all HTTP request headers
   */
  public function report(Request $request): array {
    return [
      '#theme' => 'table',
      '#header' => ['Header', 'Value'],
      '#rows' => array_map(function ($key) use ($request) {
        return [
          'data' => [
            $key,
            $request->headers->get($key),
          ],
        ];
      }, array_keys($request->headers->all())),
    ];
  }

}
