<?php

// phpcs:disable Drupal.Commenting.DocComment.MissingShort
// phpcs:disable Drupal.Commenting.DocComment.ContentAfterOpen
// phpcs:disable SlevomatCodingStandard.TypeHints.DeclareStrictTypes.IncorrectWhitespaceBeforeDeclare
/** @noinspection PhpUndefinedNamespaceInspection */
/** @noinspection PhpUndefinedClassInspection */
/** @noinspection PhpUnused */

declare(strict_types=1);

// phpcs:enable

namespace Drupal\humanstxt\Controller;

use Drupal\Core\Cache\CacheableResponse;
use Drupal\Core\Config\ConfigFactoryInterface;
use Drupal\Core\DependencyInjection\AutowireTrait;
use Drupal\Core\DependencyInjection\ContainerInjectionInterface;

/**
 * Handles the humanstxt route.
 */
class HumansTxtController implements ContainerInjectionInterface {

  use AutowireTrait;

  /**
   * Constructs a new \Drupal\humanstxt\Controller\HumansTxtController instance.
   *
   * @param \Drupal\Core\Config\ConfigFactoryInterface $configFactory
   *   The config factory.
   */
  public function __construct(
    protected ConfigFactoryInterface $configFactory,
  ) {}

  /**
   * Serves the configured humans.txt file.
   *
   * @return \Drupal\Core\Cache\CacheableResponse
   *   The content of the humans.txt file.
   *
   * @noinspection PhpMethodParametersCountMismatchInspection
   */
  public function content(): CacheableResponse {
    $content = $this->configFactory->get('humanstxt.settings')->get('content');
    $response = new CacheableResponse($content, headers: ['Content-Type' => 'text/plain']);
    $response->getCacheableMetadata()->addCacheTags(['humanstxt']);

    return $response;
  }

}
