<?php

// phpcs:disable Drupal.Commenting.DocComment.MissingShort
// phpcs:disable Drupal.Commenting.DocComment.ContentAfterOpen
// phpcs:disable SlevomatCodingStandard.TypeHints.DeclareStrictTypes.IncorrectWhitespaceBeforeDeclare
/** @noinspection PhpUndefinedNamespaceInspection */
/** @noinspection PhpUndefinedClassInspection */
/** @noinspection PhpUnused */

declare(strict_types=1);

// phpcs:enable

namespace Drupal\humanstxt\Form;

use Drupal\Core\Form\ConfigFormBase;
use Drupal\Core\Form\FormStateInterface;
use Drupal\Core\Cache\Cache;
use Symfony\Component\DependencyInjection\ContainerInterface;

/**
 * The settings form class.
 */
class HumansTxtAdminSettingsForm extends ConfigFormBase {

  protected const string CONFIG_NAME = 'humanstxt.settings';

  /**
   * {@inheritdoc}
   */
  public static function create(ContainerInterface $container): self {
    $instance = new static(
      $container->get('config.factory'),
      $container->get('config.typed')
    );
    $instance->setStringTranslation($container->get('string_translation'));

    return $instance;
  }

  /**
   * {@inheritdoc}
   */
  public function getFormId(): string {
    return 'humanstxt_admin_settings';
  }

  /**
   * {@inheritdoc}
   */
  protected function getEditableConfigNames(): array {
    return [self::CONFIG_NAME];
  }

  /**
   * {@inheritdoc}
   */
  public function buildForm(array $form, FormStateInterface $form_state): array {
    $form['about'] = [
      '#type' => 'item',
      '#markup' => $this->t(
        'Add information about people who have contributed to build the website. You can find more info on <a href=":humanstxt">humanstxt.org</a> and use <a href=":humanstxt_file">the file they provide</a> as base file.',
        [
          ':humanstxt' => 'https://humanstxt.org',
          ':humanstxt_file' => 'https://humanstxt.org/humans.txt',
        ]
      ),
    ];

    $form['content'] = [
      '#type' => 'textarea',
      '#title' => $this->t('The content returned for humans.txt'),
      '#config_target' => self::CONFIG_NAME . ':content',
      '#cols' => 60,
      '#rows' => 20,
      '#wysiwyg' => FALSE,
    ];

    $form['display_link'] = [
      '#type' => 'checkbox',
      '#title' => $this->t('Add the link to humans.txt in the document metadata'),
      '#config_target' => self::CONFIG_NAME . ':display_link',
    ];

    return parent::buildForm($form, $form_state);
  }

  /**
   * {@inheritdoc}
   */
  public function submitForm(array &$form, FormStateInterface $form_state): void {
    Cache::invalidateTags(['humanstxt']);

    parent::submitForm($form, $form_state);
  }

}
