<?php

// phpcs:disable Drupal.Commenting.DocComment.MissingShort
// phpcs:disable Drupal.Commenting.DocComment.ContentAfterOpen
// phpcs:disable SlevomatCodingStandard.TypeHints.DeclareStrictTypes.IncorrectWhitespaceBeforeDeclare
/** @noinspection PhpUnused */

declare(strict_types=1);

// phpcs:enable

namespace Drupal\humanstxt\Hook;

use Drupal\Core\Config\ConfigFactoryInterface;
use Drupal\Core\Hook\Attribute\Hook;
use Drupal\Core\Routing\RouteMatchInterface;
use Drupal\Core\StringTranslation\StringTranslationTrait;
use Drupal\Core\StringTranslation\TranslationInterface;
use Drupal\Core\Url;

/**
 * Hooks implementations for the Humans.txt module.
 */
final class HumansTxtHooks {

  use StringTranslationTrait;

  /**
   * Constructs a new \Drupal\humanstxt\Hook\HumansTxtHooks instance.
   *
   * @param \Drupal\Core\StringTranslation\TranslationInterface $string_translation
   *   The string translation service.
   * @param \Drupal\Core\Config\ConfigFactoryInterface $configFactory
   *   The configuration factory.
   */
  public function __construct(
    TranslationInterface $string_translation,
    private readonly ConfigFactoryInterface $configFactory,
  ) {
    $this->setStringTranslation($string_translation);
  }

  /**
   * Implements hook_help().
   *
   * @noinspection PhpUnusedParameterInspection
   */
  #[Hook('help')]
  public function help(string $route_name, RouteMatchInterface $route_match): ?string {
    $output = NULL;

    if ($route_name == 'help.page.humanstxt') {
      $output = '<h2>' . $this->t('About') . '</h2>';
      $output .= '<p>' . $this->t('This module generates content for <em>humans.txt</em>.') . '</p>';
      $output .= '<p>' . $this->t('For more information, visit the main site of the <a href=":humanstxt_site">Humans.txt</a> project.', [':humanstxt_site' => 'https://humanstxt.org/']) . '</p>';
      $output .= '<p>' . $this->t('They provide an <a href=":example">example</a> of <em>humans.txt</em> file which can help you to create your own.', [':example' => 'https://humanstxt.org/humans.txt']) . '</p>';
      $output .= '<h2>' . $this->t('Questions') . '</h2>';
      $output .= '<dl>';
      $output .= '<dt>' . $this->t('What is Humans.txt?') . '</dt>';
      $output .= '<dd>' . $this->t('It is an initiative for knowing the people behind a website. It is a text file that contains information about the different people who have contributed to build the website.') . '</dd>';
      $output .= '<dt>' . $this->t('Who should I mention?') . '</dt>';
      $output .= '<dd>' . $this->t('Whoever you want to, provided they wish you to do so. You can mention the developers, the designers, the copywriter, the webmaster, or the SEO, for example.') . '</dd>';
      $output .= '<dt>' . $this->t('Internet is for humans.') . '</dt>';
      $output .= '<dd>' . $this->t('We are always saying that, but the only file we generate is one full of additional information for the search bots: the robots.txt file. Then why not adding one for ourselves?') . '</dd>';
      $output .= '</dl>';
    }

    return $output;
  }

  /**
   * Implements hook_page_attachments().
   */
  #[Hook('page_attachments')]
  public function pageAttachments(array &$attachments): void {
    if ($this->configFactory->get('humanstxt.settings')->get('display_link')) {
      $attachments['#attached']['html_head_link'][] = [
        [
          'rel' => 'author',
          'type' => 'text/plain',
          'hreflang' => 'x-default',
          'href' => Url::fromRoute('humanstxt.content', [], ['absolute' => TRUE])->toString(),
        ],
        TRUE,
      ];
    }
  }

}
