<?php

// phpcs:disable Drupal.Commenting.DocComment.MissingShort
// phpcs:disable Drupal.Commenting.DocComment.ContentAfterOpen
// phpcs:disable SlevomatCodingStandard.TypeHints.DeclareStrictTypes.IncorrectWhitespaceBeforeDeclare
/** @noinspection PhpUndefinedNamespaceInspection */
/** @noinspection PhpUndefinedClassInspection */
/** @noinspection PhpUnused */

declare(strict_types=1);

// phpcs:enable

namespace Drupal\Tests\humanstxt\Functional;

use Drupal\Tests\BrowserTestBase;
use Drupal\Core\Url;
use PHPUnit\Framework\Attributes\Group;
use PHPUnit\Framework\Attributes\RunTestsInSeparateProcesses;
use Symfony\Component\HttpFoundation\Response;

/**
 * Tests basic functionality of humans.
 */
#[Group('humanstxt')]
#[RunTestsInSeparateProcesses]
class HumansTxtBasicTest extends BrowserTestBase {

  /**
   * {@inheritdoc}
   */
  protected static $modules = ['humanstxt', 'user'];

  /**
   * {@inheritdoc}
   */
  protected $defaultTheme = 'stark';

  /**
   * Tests the content type is correct.
   */
  public function testHeader() {
    $session = $this->assertSession();

    $this->drupalGet(Url::fromRoute('humanstxt.content'));
    $session->statusCodeEquals(Response::HTTP_OK);
    $session->responseHeaderEquals('Content-Type', 'text/plain; charset=UTF-8');
  }

  /**
   * Tests the cache tags are correct.
   */
  public function testCacheTags() {
    $session = $this->assertSession();

    $this->drupalGet(Url::fromRoute('humanstxt.content'));
    $session->statusCodeEquals(Response::HTTP_OK);
    $session->responseHeaderContains('X-Drupal-Cache-Tags', 'humanstxt');
  }

  /**
   * Tests the link to humans.txt is correctly added to <head>.
   */
  public function testLinkInHead() {
    $session = $this->assertSession();
    $humans_txt_url = Url::fromRoute('humanstxt.content', options: ['absolute' => TRUE])
      ->toString();
    $link = '<' . $humans_txt_url . '>; rel="author"; type="text/plain"; hreflang="x-default"';

    $this->drupalGet(Url::fromRoute('humanstxt.content'));
    $session->statusCodeEquals(Response::HTTP_OK);

    $this->drupalGet(Url::fromRoute('<front>'));
    $session->statusCodeEquals(Response::HTTP_OK);
    $session->responseHeaderEquals('Link', $link);
  }

}
