<?php

namespace Drupal\yplog\Drush\Commands;

use Drush\Attributes as CLI;
use Drush\Commands\DrushCommands;

/**
 * Provides Drush commands for YP Log module.
 */
class YpLogCommands extends DrushCommands {

  /**
   * Takes a snapshot of the current Icecast YP streams.
   */
  #[CLI\Command(name: 'icecast:yplog')]
  #[CLI\Usage(name: 'drush icecast:yplog', description: 'Takes a snapshot of the current Icecast YP streams.')]
  public function snapshot(): void {
    yplog_cron();
    if ($logger = $this->logger()) {
      $logger->success(dt('Icecast YP directory snapshot created.'));
    }
  }

}
