<?php

/**
 * @file
 * Post update functions for YP Log module.
 */

use Drupal\Core\Field\BaseFieldDefinition;

/**
 * Add yp_log.current_song field.
 */
function yplog_post_update_add_current_song(): void {
  $field = BaseFieldDefinition::create('string')
    ->setLabel(t('Current song'))
    ->setSetting('max_length', 767);
  Drupal::entityDefinitionUpdateManager()->installFieldStorageDefinition('current_song', 'yp_log', 'yplog', $field);
}
