<?php

class SchemaUtils {
  public static function encodeDate($timestamp) {
    $date = DateTime::createFromFormat('U', $timestamp);
    if ($date === false) {
      // If the timestamp is invalid, return a default value.
      $date = DateTime::createFromFormat('U', 0);
    }
    return $date
      ->setTimezone(new \DateTimeZone('UTC'))
      ->format('Y-m-d\TH:i:s\Z');
      // Note that the ATOM constant produces a format that is not allowed by
      // the JSON API parser at notifications service (Go library).
  }
}
