<?php

declare(strict_types=1);

namespace Drupal\idle_reauthenticate\Form;

use Drupal\Component\Utility\Html;
use Drupal\Core\Form\FormBase;
use Drupal\Core\Form\FormStateInterface;

/**
 * Provides a Reauthenticate on idle browser form.
 */
final class Authenticate extends FormBase {

  /**
   * {@inheritdoc}
   */
  public function getFormId(): string {
    return 'idle_reauthenticate_authenticate';
  }

  /**
   * {@inheritdoc}
   */
  public function buildForm(array $form, FormStateInterface $form_state): array {
    $form['#id'] = Html::getId($form_state->getBuildInfo()['form_id']);
    $form['password'] = [
      '#type' => 'password',
      '#title' => $this->t('Password'),
      '#required' => TRUE,
    ];
    $form['actions'] = [
      '#type' => 'actions',
      'logout' => [
        '#type' => 'submit',
        '#name' => 'logout',
        '#value' => $this->t('Not %name?', ['%name' => $this->currentUser()->getDisplayName()]),
        '#button_type' => 'danger',
        '#limit_validation_errors' => [],
        '#ajax' => [
          'callback' => '::ajaxSubmit',
        ],
      ],
      'submit' => [
        '#type' => 'submit',
        '#value' => $this->t('OK'),
        '#button_type' => 'primary',
        '#limit_validation_errors' => [],
        '#ajax' => [
          'callback' => '::ajaxSubmit',
        ],
        '#attributes' => [
          'class' => ['submit-on-return'],
        ],
      ],
    ];
    return $form;
  }

  /**
   * {@inheritdoc}
   */
  public function submitForm(array &$form, FormStateInterface $form_state): void {}

}
