(function ($, Drupal, drupalSettings, once) {
  Drupal.idleReauthenticate = {};
  Drupal.behaviors.idleReauthenticate = {
    attach: function attach() {
      $(once('idle-reauthenticate', 'body')).each(function () {
        document.addEventListener('keyup', function (event) {
          if (
            event.key === 'Enter' &&
            event.target.form !== null &&
            event.target.form !== undefined &&
            event.target.form.id === 'idle-reauthenticate-authenticate'
          ) {
            $('.ui-dialog.idle-reauthenticate button.submit-on-return').click();
          }
        });
        document.addEventListener('keydown', function (event) {
          // Lock the screen with alt + L. Use 2 keycodes as 'L' can be uppercase or lowercase.
          if (
            event.altKey === true &&
            event.ctrlKey === true &&
            (event.key === 'L' || event.key === 'l')) {
            event.preventDefault();
            Drupal.ajax({url: drupalSettings.idleReauthenticate.pingBackUrl}).execute();
          }
        });
        [
          'mousedown',
          'mousemove',
          'keydown',
          'scroll',
          'touchstart',
          'click',
        ].forEach(function (name) {
          document.addEventListener(
            name,
            Drupal.idleReauthenticate.resetTimer,
            true,
          );
        });
        Drupal.idleReauthenticate.pingBack();
      });
    },
  };

  Drupal.idleReauthenticate.resetTimer = function () {
    Drupal.idleReauthenticate.lastSeen = new Date().getTime();
  };

  Drupal.idleReauthenticate.pingBack = function () {
    const request = Drupal.ajax({
      url: drupalSettings.idleReauthenticate.pingBackUrl,
      submit: {
        currentPath: drupalSettings.path.currentPath,
        currentState: drupalSettings.idleReauthenticate.currentState,
        currentTime: new Date().getTime(),
        lastSeen: Drupal.idleReauthenticate.lastSeen,
      },
      error: function error() {
        // We have to ignore this so that no error is visible in neither the
        // UI nor the console if the user clicks away from the current page
        // while a ping is in progress.
      },
    });
    const ajaxExecute = request.execute();
    ajaxExecute.fail(function () {
      // Ignoring errors as they occur when the user navigates somewhere while an ajax ping is in progress.
    });
    setTimeout(
      Drupal.idleReauthenticate.pingBack,
      drupalSettings.idleReauthenticate.pingTime,
    );
  };
})(jQuery, Drupal, drupalSettings, once);
