<?php

declare(strict_types=1);

namespace Drupal\idle_reauthenticate\Form;

use Drupal\Core\Form\ConfigFormBase;
use Drupal\Core\Form\FormStateInterface;

/**
 * Configure Reauthenticate on idle browser settings for this site.
 */
final class Settings extends ConfigFormBase {

  /**
   * {@inheritdoc}
   */
  public function getFormId(): string {
    return 'idle_reauthenticate_settings';
  }

  /**
   * {@inheritdoc}
   */
  protected function getEditableConfigNames(): array {
    return ['idle_reauthenticate.settings'];
  }

  /**
   * {@inheritdoc}
   */
  public function buildForm(array $form, FormStateInterface $form_state): array {
    $form['ping_frequency'] = [
      '#type' => 'number',
      '#title' => $this->t('Ping frequency in seconds'),
      '#description' => $this->t('How often should each open browser tab check if the active session should be blocked.'),
      '#default_value' => $this->config('idle_reauthenticate.settings')->get('ping_frequency'),
      '#min' => 1,
    ];
    $form['idle_period'] = [
      '#type' => 'number',
      '#title' => $this->t('Idle period (in seconds)'),
      '#description' => $this->t('Time of inactivity before the active session gets blocked and requires re-authentication.'),
      '#default_value' => $this->config('idle_reauthenticate.settings')->get('idle_period'),
      '#min' => 1,
    ];
    return parent::buildForm($form, $form_state);
  }

  /**
   * {@inheritdoc}
   */
  public function submitForm(array &$form, FormStateInterface $form_state): void {
    $this->config('idle_reauthenticate.settings')
      ->set('ping_frequency', $form_state->getValue('ping_frequency'))
      ->set('idle_period', $form_state->getValue('idle_period'))
      ->save();
    parent::submitForm($form, $form_state);
  }

}
