<?php

namespace Drupal\image_404_fallback\Form;

use Drupal\Core\Form\ConfigFormBase;
use Drupal\Core\Form\FormStateInterface;

/**
 * Configure Image 404 Fallback settings.
 */
class Image404FallbackSettingsForm extends ConfigFormBase {

  /**
   * {@inheritdoc}
   */
  protected function getEditableConfigNames() {
    return ['image_404_fallback.settings'];
  }

  /**
   * {@inheritdoc}
   */
  public function getFormId() {
    return 'image_404_fallback_settings_form';
  }

  /**
   * {@inheritdoc}
   */
  public function buildForm(array $form, FormStateInterface $form_state) {
    $config = $this->config('image_404_fallback.settings');

    $form['placeholder_path'] = [
      '#type' => 'textfield',
      '#title' => $this->t('Fallback Image Path'),
      '#description' => $this->t('Enter the path to the fallback image file. This can be an absolute path or a path relative to the Drupal root. If left empty, the module will use its default fallback image.'),
      '#default_value' => $config->get('placeholder_path'),
    ];

    return parent::buildForm($form, $form_state);
  }

  /**
   * {@inheritdoc}
   */
  public function submitForm(array &$form, FormStateInterface $form_state) {
    $this->config('image_404_fallback.settings')
      ->set('placeholder_path', $form_state->getValue('placeholder_path'))
      ->save();

    parent::submitForm($form, $form_state);
  }

}
