<?php

namespace Drupal\image_blurry_placeholder\Twig;

use Drupal\image_blurry_placeholder\ImageBlurryPlaceholderManager;
use Twig\Extension\AbstractExtension;
use Twig\TwigFunction;

/**
 * Twig extension for image blurry placeholders.
 */
class ImageBlurryPlaceholderExtension extends AbstractExtension {

  /**
   * The image blurry placeholder manager.
   *
   * @var \Drupal\image_blurry_placeholder\ImageBlurryPlaceholderManager
   */
  protected $manager;

  /**
   * ImageBlurryPlaceholderExtension constructor.
   *
   * @param \Drupal\image_blurry_placeholder\ImageBlurryPlaceholderManager $manager
   *   The image blurry placeholder manager.
   */
  public function __construct(
    ImageBlurryPlaceholderManager $manager

  ) {
    $this->manager = $manager;
  }

  /**
   * {@inheritdoc}
   */
  public function getFunctions(): array {
    return [
      new TwigFunction('image_blurry_placeholder', [$this, 'getPlaceholderImage']),
    ];
  }

  /**
   * Get a placeholder image.
   */
  public function getPlaceholderImage(?string $uri): ?string {
    if (empty($uri)) {
      return NULL;
    }

    return $this->manager->getPlaceholderImage($uri);
  }

}
