<?php

/**
 * @file
 * Post update functions for image_field_caption.
 */

declare(strict_types=1);

use Drupal\Component\Utility\DiffArray;
use Drupal\Component\Utility\NestedArray;
use Drupal\image_field_caption\Plugin\Field\FieldType\ImageCaptionItem;

/**
 * Updates image field settings with new defaults.
 *
 * Export config after running to persist changes.
 */
function image_field_caption_post_update_apply_new_settings(): void {
  /** @var \Drupal\Core\Field\FieldConfigInterface[] $fields */
  $fields = \Drupal::entityTypeManager()
    ->getStorage('field_config')
    ->loadByProperties(['field_type' => 'image']);
  $default_settings = ImageCaptionItem::defaultFieldSettings();
  foreach ($fields as $field) {
    $settings = $field->getSettings();
    $updated_settings = NestedArray::mergeDeep($settings, $default_settings);
    if (DiffArray::diffAssocRecursive($settings, $updated_settings)) {
      $field->setSettings($updated_settings)->save();
    }
  }
}
