<?php

declare(strict_types=1);

namespace Drupal\image_field_caption\Plugin\Field\FieldFormatter;

use Drupal\Core\Field\Attribute\FieldFormatter;
use Drupal\Core\Field\FieldItemListInterface;
use Drupal\Core\StringTranslation\TranslatableMarkup;
use Drupal\image\Plugin\Field\FieldFormatter\ImageFormatter;

/**
 * Plugin implementation of the 'image_caption' formatter.
 */
#[FieldFormatter(
  id: 'image_caption',
  label: new TranslatableMarkup('Image with caption'),
  field_types: ['image'],
)]
class ImageCaptionFormatter extends ImageFormatter {

  /**
   * {@inheritdoc}
   */
  public function viewElements(FieldItemListInterface $items, $langcode): array {
    // Overrides the theme to display a caption.
    $elements = parent::viewElements($items, $langcode);
    foreach ($elements as &$element) {
      $element['#theme'] = 'image_caption_formatter';
    }
    return $elements;
  }

}
