<?php

/**
 * @file
 * Post update functions for image_field_caption.
 */

declare(strict_types=1);

use Drupal\image_field_caption\Plugin\Field\FieldType\ImageCaptionItem;

/**
 * Updates image field settings with new defaults.
 *
 * Export config after running to persist changes.
 */
function image_field_caption_post_update_apply_new_settings(): void {
  /** @var \Drupal\Core\Field\FieldConfigInterface[] $fields */
  $fields = \Drupal::entityTypeManager()
    ->getStorage('field_config')
    ->loadByProperties(['field_type' => 'image']);
  $default_settings = ImageCaptionItem::defaultFieldSettings();
  foreach ($fields as $field) {
    $field->setSettings($field->getSettings() + $default_settings)->save();
  }
}
