<?php

declare(strict_types=1);

namespace Drupal\image_field_caption\Plugin\Field\FieldFormatter;

use Drupal\Core\Field\EntityReferenceFieldItemListInterface;
use Drupal\Core\Field\FieldItemListInterface;

/**
 * Provides a base implementation for image formatters with a caption.
 */
trait ImageCaptionFormatterTrait {

  /**
   * {@inheritdoc}
   */
  public function viewElements(FieldItemListInterface $items, $langcode): array {
    // Overrides the theme to display a caption.
    if ($elements = parent::viewElements($items, $langcode)) {
      $theme = $this->getElementTheme();
      foreach ($elements as &$element) {
        $element['#theme'] = $theme;
      }
    }
    return $elements;
  }

  /**
   * {@inheritdoc}
   */
  protected function getEntitiesToView(EntityReferenceFieldItemListInterface $items, $langcode): array {
    $entities = parent::getEntitiesToView($items, $langcode);
    // @phpstan-ignore property.notFound
    if (count($entities) === 1 && ($item = $entities[0]->_referringItem) && $item->_is_default) {
      $default_image = $items->getSetting('default_image');
      $item->set('caption', $default_image['caption'] ?? '');
      $item->set('caption_format', $default_image['caption_format'] ?? filter_default_format());
    }
    return $entities;
  }

  /**
   * Returns the #theme for the element.
   *
   * @return string
   *   The #theme.
   */
  abstract protected function getElementTheme(): string;

}
