<?php

/**
 * @file
 * Post update functions for image_field_caption.
 */

declare(strict_types=1);

use Drupal\Component\Utility\NestedArray;
use Drupal\image_field_caption\Plugin\Field\FieldType\ImageCaptionItem;

/**
 * Updates image field settings with new defaults.
 *
 * Export config after running to persist changes.
 */
function image_field_caption_post_update_apply_new_settings_2(): void {
  /** @var \Drupal\Core\Field\FieldConfigInterface[] $fields */
  $fields = \Drupal::entityTypeManager()
    ->getStorage('field_config')
    ->loadByProperties(['field_type' => 'image']);
  $default_settings = ImageCaptionItem::defaultFieldSettings();
  $old_key = 'caption_allowed_formats';
  $new_key = 'caption_field_allowed_formats';
  foreach ($fields as $field) {
    $settings = $field->getSettings();
    if (array_key_exists($old_key, $settings)) {
      $allowed_formats = $settings[$old_key];
      unset($settings[$old_key]);
      $settings[$new_key] = $allowed_formats;
    }
    $field->setSettings(NestedArray::mergeDeep($default_settings, $settings))->save();
  }
}
