<?php

declare(strict_types=1);

namespace Drupal\image_field_caption\Plugin\Field\FieldFormatter;

use Drupal\Core\Field\Attribute\FieldFormatter;
use Drupal\Core\StringTranslation\TranslatableMarkup;
use Drupal\responsive_image\Plugin\Field\FieldFormatter\ResponsiveImageFormatter;

/**
 * Plugin implementation of the 'responsive_image_caption' formatter.
 */
#[FieldFormatter(
  id: 'responsive_image_caption',
  label: new TranslatableMarkup('Responsive image with caption'),
  field_types: ['image'],
)]
class ResponsiveImageCaptionFormatter extends ResponsiveImageFormatter {

  use ImageCaptionFormatterTrait;

  /**
   * {@inheritdoc}
   */
  protected function getElementTheme(): string {
    return 'responsive_image_caption_formatter';
  }

  /**
   * {@inheritdoc}
   */
  public function calculateDependencies(): array {
    $dependencies = parent::calculateDependencies();
    $dependencies['module'][] = 'responsive_image';
    return $dependencies;
  }

}
