<?php

/**
 * @file
 * Post update functions for image_field_caption.
 */

declare(strict_types=1);

use Drupal\Core\Cache\Cache;
use Drupal\image_field_caption\Form\ImageFieldCaptionSemanticModeForm;
use Drupal\image_field_caption\Plugin\Field\FieldType\ImageCaptionItem;

/**
 * Updates image field settings with new defaults.
 *
 * Export config after running to persist changes.
 */
function image_field_caption_post_update_apply_new_settings_3(): void {
  /** @var \Drupal\Core\Field\FieldConfigInterface[] $fields */
  $fields = \Drupal::entityTypeManager()
    ->getStorage('field_config')
    ->loadByProperties(['field_type' => 'image']);
  $default_settings = ImageCaptionItem::defaultFieldSettings();
  $renamed_keys = [
    'caption_allowed_formats' => 'caption_field_allowed_formats',
  ];
  foreach ($fields as $field) {
    $settings = $field->getSettings();
    foreach ($renamed_keys as $old_key => $new_key) {
      if (array_key_exists($old_key, $settings)) {
        $value = $settings[$old_key];
        unset($settings[$old_key]);
        $settings[$new_key] = $value;
      }
    }
    $settings += $default_settings;
    $settings['default_image'] += $default_settings['default_image'];
    $field->setSettings($settings)->save();
  }
}

/**
 * Disables semantic mode for existing users.
 */
function image_field_caption_post_update_disable_semantic_mode(): void {
  // @phpstan-ignore classConstant.internalClass
  \Drupal::state()->set(ImageFieldCaptionSemanticModeForm::STATE_KEY, FALSE);
  // @phpstan-ignore classConstant.internalClass
  Cache::invalidateTags([ImageFieldCaptionSemanticModeForm::STATE_KEY]);
}
