# Image Field Caption

This module extends Drupal's image field functionality by adding a dedicated
text area for captions.

Similar to the `alt` and `title` attributes,
the caption field allows users to provide descriptive text or HTML content
for images.

---

## Table of Contents

1. [Requirements](#requirements)
2. [Installation](#installation)
3. [Usage](#usage)
4. [Configuration](#configuration)
5. [Troubleshooting](#troubleshooting)
6. [Caption Theming](#caption-theming)
7. [Caption CSS](#caption-css)

---

## Requirements

This module requires no modules outside of Drupal core.

---

## Installation

Install as you would normally install a contributed Drupal module.
Visit https://www.drupal.org/node/1897420 for further information.

---

## Usage

1. **Add or configure an image field**:
   - Add a new image field to a content type or edit an existing one.
   - On the "Manage display" tab, set the field format
     to **"Image with caption"**.

2. **Enable the caption field**:
   - Check the "Enable Caption field" checkbox in the field settings.

3. **Add or edit content**:
   - Create or edit a node or entity with the configured image field.
   - Enter text or HTML into the caption text area and select
     the desired text format.

4. **Save and view**:
   - Save the entity and view it to see the caption displayed with the image.

---

## Configuration

- Configuration is performed on a **per-field basis**.
- Adjust settings for each image field under the "Manage display" tab.

---

## Troubleshooting

- **Issue**: Caption text area not displaying under the image field.
  - **Solution**: Clear Drupal's cache
    - Via Drupal UI: `Admin > Configuration > Performance > Clear all caches`.
    - Or using Drush: `drush cr`.

---

## Caption Theming

  By default, an image field's caption will be rendered below the image.
  To customize the image caption display,
  copy the image-caption-formatter.html.twig file
  to your theme's directory and adjust the html for your needs.
  Flush Drupal's theme registry cache to have
  it recognize your theme's new file:

1. Copy the `image-caption-formatter.html.twig` file from the module to your
   theme directory.
2. Modify the HTML structure as needed.
3. Clear the theme registry cache:
   - Via Drupal UI: `Admin > Configuration > Performance > Clear all caches`.
   - Or using Drush: `drush cr`.

---

## Caption CSS

To style captions added by this module, use the following CSS selectors:
```css
.caption.image-field-caption {
  /* Add custom styles for the caption container here. */
}
.caption.image-field-caption > figcaption {
  /* Add custom styles for the actual caption text here. */
}
```
