<?php

declare(strict_types=1);

namespace Drupal\image_field_caption\Plugin\Field\FieldFormatter;

use Drupal\Core\Field\Attribute\FieldFormatter;
use Drupal\Core\StringTranslation\TranslatableMarkup;
use Drupal\image\Plugin\Field\FieldFormatter\ImageFormatter;

/**
 * Plugin implementation of the 'image_caption' formatter.
 */
#[FieldFormatter(
  id: 'image_caption',
  label: new TranslatableMarkup('Image with caption'),
  field_types: ['image'],
)]
class ImageCaptionFormatter extends ImageFormatter {
  use ImageCaptionFormatterTrait;

  /**
   * {@inheritdoc}
   */
  protected function getElementTheme(): string {
    return 'image_caption_formatter';
  }

}
